#!/bin/bash
# KillSpider 安装脚本

if [ "$EUID" -ne 0 ]; then
    echo "错误: 请使用 sudo 运行安装脚本"
    echo "用法: sudo ./install.sh"
    exit 1
fi

echo "=== 安装 KillSpider ==="

# 安装目录
INSTALL_DIR="/opt/killspider"

echo "1. 创建安装目录..."
mkdir -p "$INSTALL_DIR"

echo "2. 复制文件..."
cp -r ./* "$INSTALL_DIR/"

echo "3. 设置权限..."
chmod 755 "$INSTALL_DIR/KillSpider"
chmod 755 "$INSTALL_DIR/start.sh" 2>/dev/null || true

echo "4. 创建命令行快捷方式..."
ln -sf "$INSTALL_DIR/KillSpider" /usr/local/bin/killspider

echo ""
echo "✅ 安装完成！"
echo ""
echo "使用方法:"
echo "  运行程序: killspider"
echo "  查看帮助: killspider --help"
echo ""
echo "配置文件: $INSTALL_DIR/config.json"
echo "配置目录: $INSTALL_DIR/config/"
